#include <algorithm>
#include <iostream>
#include <vector>

using ll = long long;
ll MOD = 998'244'353;

ll mod_pow(ll base, ll power) {
    if (power == 0)
        return 1;
    else if (power % 2 == 0) {
        ll a = mod_pow(base, power / 2);
        return (a * a) % MOD;
    } else {
        return (base * mod_pow(base, power - 1)) % MOD;
    }
}

int main() {
    int t;
    std::cin >> t;
    for (int step = 0; step < t; ++step) {
        ll n, m;
        std::cin >> n >> m;

        std::vector<ll> m1n(n);
        m1n[0] = 1;
        for (ll i = 1; i < m1n.size(); ++i) {
            m1n[i] = (m1n[i - 1] * (m - 1)) % MOD;
        }

        ll sum_l = (m * m1n[n - 1]) % MOD;
        for (ll i = 2; i <= n; ++i) {
            ll a = (m * m1n[n - i]) % MOD;
            a = (a * (n - i + 1)) % MOD;
            a = (a * i) % MOD;
            sum_l += a;
        }

        ll length_s = mod_pow(m, n);

        ll k = 0;
        while ((k * MOD + sum_l) % length_s != 0) {
            k++;
        }
        ll x = (k * MOD + sum_l) / length_s;
        std::cout << x << "\n";
    }
}